#include <Blobs/StdV3D.h>

#include <limits>
#include "Maths.h"

namespace V3D {

const double k_dPiDiv2 = 0.5 * 3.1415926535897932384626433832795029;
const double k_dPi = 3.1415926535897932384626433832795029;
const double k_d2Pi = 2 * 3.1415926535897932384626433832795029;


const float  k_fPiDiv2 = 0.5 * 3.1415926535897932384626433832795029f;
const float  k_fPi = 3.1415926535897932384626433832795029f;
const float  k_f2Pi = 2 * 3.1415926535897932384626433832795029f;

const double k_dSqrt2 = 1.4142135623730950488016887242097;
const double k_dSqrt3 = 1.7320508075688772935274463415059;
const double k_dSqrt3Div2 = 0.8660254037844386;

const float  k_fSqrt2     = 1.4142135623730950488016887242097f;
const float  k_fSqrt3     = 1.7320508075688772935274463415059f;
const float  k_fSqrt3Div2 = 0.8660254037844386f;



static const double k_dMinInt32 = std::numeric_limits<int32>::min();
static const double k_dMaxInt32 = std::numeric_limits<int32>::max();

inline int ftoi_fast(float f)
{
    int i;

    __asm
    {
        fld f
        fistp i
    }

    return i;
}

// Attention : suppose un arrondi au plus proche (option /QIfist du compilateur vc++ 7)
int32 FloorFast( const double f)
{
    //int32 res = int32( f - .499999999);
    //int32 res = ftoi_fast(f - .499999999);
	//auto test =  fabs( floor(f)  - res);
    //assert((test) < 1E-3);
	//return res; 
    return Floor(f);
}

int32 CeilFast( const double f)
{ 
     //int32 res = ftoi_fast(f + .499999999);
     //auto test = fabs( ceil(f) - res);
     //assert( test < 1E-3);
     //return res;
    return Ceil(f);
}


int32 Floor( const double f)
{
	double dFloor = Clamp( floor(f), k_dMinInt32, k_dMaxInt32 );
	return int32( dFloor ); 
}

int32 Ceil( const double f)
{
	double dCeil = Clamp( ceil(f), k_dMinInt32, k_dMaxInt32 );
	return int32( dCeil ); 
}


} // namespaces
